/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.tree;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.uno.RuntimeException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.openoffice.accessibility.awb.tree.AccessibilityModel;
import org.openoffice.accessibility.misc.NameProvider;

public class AccessibilityTree
extends JTree {
    public AccessibilityTree(TreeModel treeModel) {
        super(treeModel);
        this.showsRootHandles = true;
    }

    public void setToolkit(XExtendedToolkit xExtendedToolkit) {
        AccessibilityModel accessibilityModel = (AccessibilityModel)this.getModel();
        if (accessibilityModel != null) {
            this.setRootVisible(xExtendedToolkit == null);
            accessibilityModel.setRoot(xExtendedToolkit);
            accessibilityModel.reload();
        }
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object2;
        if (object instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) != null && object2 instanceof XAccessible) {
            XAccessible xAccessible = (XAccessible)object2;
            try {
                XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
                if (xAccessibleContext != null) {
                    String string = xAccessibleContext.getAccessibleName();
                    if (string.length() == 0) {
                        string = new String("<no name>");
                    }
                    object = string + " / " + NameProvider.getRoleName(xAccessibleContext.getAccessibleRole());
                }
            }
            catch (RuntimeException runtimeException) {
                object = "???";
            }
        }
        return super.convertValueToText(object, bl, bl2, bl3, n, bl4);
    }
}

